<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder\Entity;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;

class DoctrineEntityEntityDataBuilder extends AbstractEntityDataBuilder
{
    protected bool $useAttributes = false;

    public function build(Entity $entity): array
    {
        $data = $this->buildEntity($entity);

        foreach ($entity->fields as $field) {
            $data['fields'][] = $this->buildField($field) + [
                    'id' => $field->id,
                ];

            $data['getters'][] = $this->buildGetter($field);
            $data['setters'][] = $this->buildSetter($field, $data['classShortName']);

            if ($this->isArrayItemSpecified($field->type)) {
                $data['adder'][] = $this->buildAdder($field->name, $field->type, $data['classShortName']);
            }
        }

        return $data;
    }
}
