<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DoctrineWriteDataSource;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;
use XCart\Bundle\DTOGeneratorBundle\DataSource\GeneratedDataSourceInterface;

class DataSourceWriteDataBuilder extends AbstractDataBuilder
{
    public function build(Entity $entity): array
    {
        $className = $this->nameResolver->buildDataSourceWriteClassName($entity->className);

        return [
            'namespace'      => ClassNameAssembler::assembleNamespace($className),
            'classNameShort' => ClassNameAssembler::assembleShortName($className),
            'uses'           => [
                DoctrineWriteDataSource::class,
                GeneratedDataSourceInterface::class,
            ],
            'interfaces'     => [
                'GeneratedDataSourceInterface',
                ClassNameAssembler::assembleShortName(
                    $this->nameResolver->buildDataSourceReadInterfaceName($entity->className),
                ),
                ClassNameAssembler::assembleShortName(
                    $this->nameResolver->buildDataSourceWriteInterfaceName($entity->className),
                ),
            ],
            'extends'        => 'DoctrineWriteDataSource',
            'traits'         => [],
        ];
    }
}
