<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\ReadDataSourceInterface;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\FilterInterface;
use XCart\Bundle\DoctrineBridgeBundle\DTO\OrderRule\OrderRuleInterface;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;

class DataSourceReadInterfaceDataBuilder extends AbstractDataBuilder
{
    public function build(Entity $entity): array
    {
        $className = $this->nameResolver->buildDataSourceReadInterfaceName($entity->className);

        return [
            'namespace'      => ClassNameAssembler::assembleNamespace($className),
            'classNameShort' => ClassNameAssembler::assembleShortName($className),
            'uses'           => [
                $entity->className . ' as Entity',
                $this->nameResolver->buildCollectionClassName($entity->className) . ' as EntityCollection',
                FilterInterface::class,
                OrderRuleInterface::class,
                ReadDataSourceInterface::class
            ],
            'extends'        => 'ReadDataSourceInterface',
        ];
    }
}
