<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DoctrineReadDataSource;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;
use XCart\Bundle\DTOGeneratorBundle\DataSource\GeneratedDataSourceInterface;

class DataSourceReadDataBuilder extends AbstractDataBuilder
{
    public function build(Entity $entity): array
    {
        $className = $this->nameResolver->buildDataSourceReadClassName($entity->className);

        return [
            'namespace'      => ClassNameAssembler::assembleNamespace($className),
            'classNameShort' => ClassNameAssembler::assembleShortName($className),
            'uses'           => [
                DoctrineReadDataSource::class,
                GeneratedDataSourceInterface::class,
            ],
            'interfaces'     => [
                'GeneratedDataSourceInterface',
                ClassNameAssembler::assembleShortName(
                    $this->nameResolver->buildDataSourceReadInterfaceName($entity->className),
                ),
            ],
            'extends'        => 'DoctrineReadDataSource',
            'traits'         => [],
        ];
    }
}
