<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Criteria;
use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DoctrineBridgeBundle\Collection\EntityCollectionInterface;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\APIEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTO;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicRequestEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicResponseEntity;
use XCart\Bundle\DTOGeneratorBundle\DTO\GeneratedCollectionInterface;

class CollectionDataBuilder extends AbstractDataBuilder
{
    /**
     * @param APIEntity|DoctrineEntity|LogicEntity|LogicRequestEntity|LogicResponseEntity|DTO $entity
     */
    public function build($entity): array
    {
        $className = $entity->className . 'Collection';

        $result = [
            'namespace'       => ClassNameAssembler::assembleNamespace($className),
            'classNameShort'  => ClassNameAssembler::assembleShortName($className),
            'entityClassName' => $entity->className,
            'uses'            => [
                \Closure::class,
                ArrayCollection::class,
                Criteria::class,
                $entity->className . ' as Entity',
                GeneratedCollectionInterface::class,
            ],
            'interfaces'      => [
                'GeneratedCollectionInterface',
            ],
            'extends'         => 'ArrayCollection',
        ];

        if ($entity instanceof DoctrineEntity) {
            $result['uses'][] = EntityCollectionInterface::class;
            $result['interfaces'][] = 'EntityCollectionInterface';
        }

        return $result;
    }
}
