<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Builder;

use XCart\Bundle\CommonBundle\DTO\Id\IdIntegerNullableTrait;
use XCart\Bundle\CommonBundle\DTO\Id\IdIntegerTrait;
use XCart\Bundle\CommonBundle\DTO\Id\IdUUID4NullableTrait;
use XCart\Bundle\CommonBundle\DTO\Id\IdUUID4Trait;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicEntity as Entity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\LogicEntitiesDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\Service\NameResolverInterface;

class NewLogicEntityBuilder implements BuilderInterface
{
    public function __construct(
        private DataProvider $dataProvider,
        private NameResolverInterface $nameResolver,
    ) {
    }

    public function build(): void
    {
        /** @var Entity $entity */
        foreach ($this->dataProvider as $entity) {
            if ($entity->generateNewEntity) {
                $this->dataProvider->add($this->addNewEntity($entity));
            }
        }
    }

    private function addNewEntity(Entity $entity): Entity
    {
        $new = clone $entity;
        $new->className = $this->nameResolver->buildNewEntityClassName($new->className);
        if (in_array(IdIntegerTrait::class, $new->traits)) {
            $new->traits[array_search(IdIntegerTrait::class, $new->traits)] = IdIntegerNullableTrait::class;
        } elseif (in_array(IdUUID4Trait::class, $new->traits)) {
            $new->traits[array_search(IdUUID4Trait::class, $new->traits)] = IdUUID4NullableTrait::class;
        } elseif (isset($new->fields['id'])) {
            $new->fields['id']->nullable = true;
        }

        $new->useDoctrineGetOne = false;
        $new->useDoctrineGetCollection = false;
        $new->useDoctrineCreateOne = false;
        $new->useDoctrineUpdateOne = false;
        $new->useDoctrineDeleteOne = false;

        $new->new = true;

        foreach ($entity->annotations as $k => $annotation) {
            $entity->annotations[$k] = clone $annotation;
        }

        foreach ($entity->fields as $k => $field) {
            $field = clone $field;
            foreach ($field->annotations as $k2 => $annotation) {
                $field->annotations[$k2] = clone $annotation;
            }

            $entity->fields[$k] = $field;
        }

        return $new;
    }
}
