<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Builder;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\LogicEntitiesDataProvider;
use XCart\Bundle\DTOGeneratorBundle\Enum\DTOType;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTO;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTODataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DoctrineEntitiesDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\Service\NameResolverInterface;

class DoctrineFiltersBuilder implements BuilderInterface
{
    public function __construct(
        private DataProvider $dataProvider,
        private LogicEntitiesDataProvider $logicEntitiesDataProvider,
        private DTODataProvider $DTODataProvider,
        private NameResolverInterface $nameResolver,
    ) {
    }

    public function build(): void
    {
        /** @var LogicEntity $entity */
        foreach ($this->logicEntitiesDataProvider as $entity) {
            if (!$entity->doctrineEntity) {
                continue;
            }

            $this->addFilterForStaticDoctrineEntity($entity);
        }
    }

    private function addFilterForStaticDoctrineEntity(LogicEntity $entity): void
    {
        // Add / detect filter sub DTO
        $filter = null;
        $filterClassName = $this->nameResolver->buildDoctrineGetListFilterClassName($entity);
        /** @var DTO $dto */
        foreach ($this->DTODataProvider as $dto) {
            if ($dto->className === $filterClassName) {
                $filter = $dto;
                break;
            }
        }

        if (!$filter) {
            $filter = new DTO();
            $filter->className = $filterClassName;
            $filter->type = DTOType::DOCTRINE_ENTITY_FILTER();
            $filter->collection = false;
            $this->DTODataProvider->add($filter);
        }

        // Add / detect order rule sub DTO
        $orderRule = null;
        $orderRuleClassName = $this->nameResolver->buildDoctrineGetListOrderRuleClassName($entity);
        /** @var DTO $dto */
        foreach ($this->DTODataProvider as $dto) {
            if ($dto->className === $orderRuleClassName) {
                $orderRule = $dto;
                break;
            }
        }

        if (!$orderRule) {
            $orderRule = new DTO();
            $orderRule->className = $orderRuleClassName;
            $orderRule->type = DTOType::DOCTRINE_ENTITY_ORDER_RULE();
            $orderRule->collection = false;
            $this->DTODataProvider->add($orderRule);
        }
    }
}
