<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Builder;

use InvalidArgumentException;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\APIEntity as Entity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Transformer;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\APIEntitiesDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\LogicEntitiesDataProvider as LogicEntityDataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\TransformersDataProvider;
use XCart\Bundle\DTOGeneratorBundle\Service\NameResolverInterface;

class APITransformersBuilder implements BuilderInterface
{
    public function __construct(
        private DataProvider $dataProvider,
        private LogicEntityDataProvider $logicEntitiesDataProvider,
        private TransformersDataProvider $transformersDataProvider,
        private NameResolverInterface $nameResolver,
    ) {
    }

    public function build(): void
    {
        /** @var Entity $entity */
        foreach ($this->dataProvider as $entity) {
            if (!$entity->logicEntity) {
                continue;
            }

            $this->addTransformer($entity->logicEntity, $entity->className);
            $this->addTransformer($entity->className, $entity->logicEntity);

            // Process new entities
            $logicEntity = null;
            /** @var LogicEntity $logicEntity */
            foreach ($this->logicEntitiesDataProvider as $subEntity) {
                if ($subEntity->className === $entity->logicEntity) {
                    $logicEntity = $subEntity;
                    break;
                }
            }

            if (!$logicEntity) {
                throw new InvalidArgumentException(
                    sprintf('Cannot find logic entity "%s"', $entity->logicEntity)
                );
            }

            $newClassName = $this->nameResolver->buildNewEntityClassName($logicEntity->className);

            $this->addTransformer($newClassName, $entity->className);
            $this->addTransformer($entity->className, $newClassName);
        }
    }

    private function addTransformer(string $from, string $to): void
    {
        $transformer = new Transformer();
        $transformer->from = $from;
        $transformer->to = $to;

        $this->transformersDataProvider->add($transformer);
    }
}
