<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Serializer\Construction;

use JMS\Serializer\Construction\ObjectConstructorInterface;
use JMS\Serializer\DeserializationContext;
use JMS\Serializer\Metadata\ClassMetadata;
use JMS\Serializer\Visitor\DeserializationVisitorInterface;
use Symfony\Component\DependencyInjection\ServiceLocator;
use XCart\Bundle\CommonBundle\Factory\GeneratedFactoryInterface;

class UnserializeObjectConstructorDecorator implements ObjectConstructorInterface
{
    public function __construct(
        private ObjectConstructorInterface $inner,
        private ServiceLocator $locator,
    ) {
    }

    public function construct(DeserializationVisitorInterface $visitor, ClassMetadata $metadata, $data, array $type, DeserializationContext $context): ?object
    {
        if ($this->locator->has($metadata->name)) {
            /** @var GeneratedFactoryInterface $factory */
            $factory = $this->locator->get($metadata->name);

            return $factory->create();
        }

        return $this->inner->construct($visitor, $metadata, $data, $type, $context);
    }
}
