<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DTOGeneratorBundle\Enum;

use MyCLabs\Enum\Enum;

/**
 * @method static LOGIC_RESPONSE_ITEM_PAYLOAD()
 * @method static LOGIC_RESPONSE_COLLECTION_PAYLOAD()
 * @method static LOGIC_REQUEST_ITEM_PAYLOAD()
 */
class TransformerType extends Enum
{
    public const LOGIC_RESPONSE_ITEM_PAYLOAD = 'logic_response_item_payload';
    public const LOGIC_RESPONSE_COLLECTION_PAYLOAD = 'logic_response_collection_payload';
    public const LOGIC_REQUEST_ITEM_PAYLOAD = 'logic_request_item_payload';

    public function isLogicResponseItemPayload(): bool
    {
        return $this->getValue() === self::LOGIC_RESPONSE_ITEM_PAYLOAD;
    }

    public function isLogicResponseCollectionPayload(): bool
    {
        return $this->getValue() === self::LOGIC_RESPONSE_COLLECTION_PAYLOAD;
    }

    public function isLogicRequestItemPayload(): bool
    {
        return $this->getValue() === self::LOGIC_REQUEST_ITEM_PAYLOAD;
    }
}
