<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DTOGeneratorBundle\Enum;

use MyCLabs\Enum\Enum;

/**
 * @method static SERIALIZATION()
 * @method static DIRECT()
 * @method static DIRECT_TO()
 * @method static DIRECT_FROM()
 */
final class TransformerPattern extends Enum
{
    public const PREDEFINED = 'predefined';
    public const SERIALIZATION = 'serialization';
    public const DIRECT = 'direct';
    public const DIRECT_TO = 'direct_to';
    public const DIRECT_FROM = 'direct_from';

    public function isPreDefined(): bool
    {
        return $this->getValue() === self::PREDEFINED;
    }

    public function isSerialization(): bool
    {
        return $this->getValue() === self::SERIALIZATION;
    }

    public function isDirect(): bool
    {
        return $this->getValue() === self::DIRECT;
    }

    public function isDirectTo(): bool
    {
        return $this->getValue() === self::DIRECT_TO;
    }

    public function isDirectFrom(): bool
    {
        return $this->getValue() === self::DIRECT_FROM;
    }
}
