<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DTOGeneratorBundle\Enum;

use MyCLabs\Enum\Enum;

/**
 * @method static GET_ONE()
 * @method static GET_COLLECTION()
 * @method static CREATE_ONE()
 * @method static CREATE_COLLECTION()
 * @method static UPDATE_ONE()
 * @method static UPDATE_COLLECTION()
 * @method static DELETE_ONE()
 * @method static DELETE_COLLECTION()
 */
class LogicResponseType extends Enum
{
    public const GET_ONE = 'get_one';
    public const GET_COLLECTION = 'get_collection';
    public const CREATE_ONE = 'create_one';
    public const CREATE_COLLECTION = 'create_collection';
    public const UPDATE_ONE = 'update_one';
    public const UPDATE_COLLECTION = 'update_collection';
    public const DELETE_ONE = 'delete_one';
    public const DELETE_COLLECTION = 'delete_collection';

    public function isGetOne(): bool
    {
        return $this->getValue() === self::GET_ONE;
    }

    public function isGetCollection(): bool
    {
        return $this->getValue() === self::GET_COLLECTION;
    }

    public function isCreateOne(): bool
    {
        return $this->getValue() === self::CREATE_ONE;
    }

    public function isCreateCollection(): bool
    {
        return $this->getValue() === self::CREATE_COLLECTION;
    }

    public function isUpdateOne(): bool
    {
        return $this->getValue() === self::UPDATE_ONE;
    }

    public function isUpdateCollection(): bool
    {
        return $this->getValue() === self::UPDATE_COLLECTION;
    }

    public function isDeleteOne(): bool
    {
        return $this->getValue() === self::DELETE_ONE;
    }

    public function isDeleteCollection(): bool
    {
        return $this->getValue() === self::DELETE_COLLECTION;
    }
}
