<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DTOGeneratorBundle\Enum;

use MyCLabs\Enum\Enum;

/**
 * @method static LOGIC_REQUEST_GET_LIST_FILTER()
 * @method static LOGIC_REQUEST_GET_LIST_ORDER_RULE()
 * @method static DOCTRINE_ENTITY_FILTER()
 * @method static DOCTRINE_ENTITY_ORDER_RULE()
 */
final class DTOType extends Enum
{
    public const LOGIC_REQUEST_GET_LIST_FILTER = 'logic_request_get_list_filter';
    public const LOGIC_REQUEST_GET_LIST_ORDER_RULE = 'logic_request_get_list_order_rule';
    public const DOCTRINE_ENTITY_FILTER = 'doctrine_entity_filter';
    public const DOCTRINE_ENTITY_ORDER_RULE = 'doctrine_entity_order_rule';

    public function isLogicRequestGetListFilter(): bool
    {
        return $this->getValue() === self::LOGIC_REQUEST_GET_LIST_FILTER;
    }

    public function isLogicRequestGetListOrderRule(): bool
    {
        return $this->getValue() === self::LOGIC_REQUEST_GET_LIST_ORDER_RULE;
    }

    public function isDoctrineEntityFilter(): bool
    {
        return $this->getValue() === self::DOCTRINE_ENTITY_FILTER;
    }

    public function isDoctrineEntityOrderRule(): bool
    {
        return $this->getValue() === self::DOCTRINE_ENTITY_ORDER_RULE;
    }
}
