<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\NodeBuilder;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;
use XCart\Bundle\DTOGeneratorBundle\Component\Config\Definition\Builder\MixedNodeDefinition;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $nodeBuilder = new NodeBuilder();
        $nodeBuilder->setNodeClass('mixed', MixedNodeDefinition::class);
        $treeBuilder = new TreeBuilder('dto_generator', 'array', $nodeBuilder);

        $treeBuilder->getRootNode()
            ->children()
                ->scalarNode('directory')->isRequired()->end()
                ->scalarNode('namespace')->isRequired()->end()
                ->scalarNode('appPrefix')->isRequired()->end()
                ->arrayNode('entities')
                    ->beforeNormalization()->castToArray()->end()
                ->end()
            ->end()
        ;

        $entitiesBuilder = $treeBuilder->getRootNode()->getChildNodeDefinitions()['entities']->children();
        $this->buildAPIEntitiesConfigurationNode($entitiesBuilder);
        $this->buildDoctrineEntitiesConfigurationNode($entitiesBuilder);
        $this->buildLogicEntitiesConfigurationNode($entitiesBuilder);
        $this->buildLogicRequestEntitiesConfigurationNode($entitiesBuilder);
        $this->buildLogicResponseEntitiesConfigurationNode($entitiesBuilder);
        $this->buildDTOConfigurationNode($entitiesBuilder);
        $this->buildTransformers($treeBuilder->getRootNode()->children());
        $this->buildEnumerations($treeBuilder->getRootNode()->children());
        $this->buildHashMaps($treeBuilder->getRootNode()->children());

        return $treeBuilder;
    }

    private function buildAPIEntitiesConfigurationNode(NodeBuilder $parent): void
    {
        $parent
            ->arrayNode('api')
                ->beforeNormalization()->castToArray()->end()
                ->useAttributeAsKey('className')
                ->arrayPrototype()
                    ->children()
                        ->scalarNode('idType')->defaultValue('int')->end()
                        ->scalarNode('logicEntity')->defaultNull()->end()
                        ->scalarNode('path')->isRequired()->end()
                        ->scalarNode('name')->defaultNull()->end()
                        ->arrayNode('traits')
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('interfaces')
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('annotations')
                            ->arrayPrototype()
                                ->prototype('mixed')->end()
                            ->end()
                        ->end()
                        ->arrayNode('factory')
                            ->children()
                                ->arrayNode('interfaces')
                                    ->scalarPrototype()->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('normalizationContext')
                            ->beforeNormalization()->castToArray()->end()
                            ->children()
                                ->arrayNode('groups')
                                    ->scalarPrototype()->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('denormalizationContext')
                            ->beforeNormalization()->castToArray()->end()
                            ->children()
                                ->arrayNode('groups')
                                    ->scalarPrototype()->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('itemOperations')
                            ->beforeNormalization()->castToArray()->end()
                            ->useAttributeAsKey('operationId')
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('method')->isRequired()->end()
                                    ->scalarNode('path')->isRequired()->end()
                                    ->arrayNode('identifiers')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('requirements')
                                        ->useAttributeAsKey('name')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('openapi_context')
                                        ->prototype('mixed')->end()
                                    ->end()
                                    ->arrayNode('normalization_context')
                                        ->children()
                                            ->arrayNode('groups')
                                                ->scalarPrototype()->end()
                                            ->end()
                                        ->end()
                                    ->end()
                                    ->arrayNode('denormalization_context')
                                        ->children()
                                            ->arrayNode('groups')
                                                ->scalarPrototype()->end()
                                            ->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('collectionOperations')
                            ->beforeNormalization()->castToArray()->end()
                            ->useAttributeAsKey('operationId')
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('method')->isRequired()->end()
                                    ->scalarNode('path')->isRequired()->end()
                                    ->arrayNode('identifiers')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('requirements')
                                        ->useAttributeAsKey('name')
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('openapi_context')
                                        ->prototype('mixed')->end()
                                    ->end()
                                    ->arrayNode('normalization_context')
                                        ->children()
                                            ->arrayNode('groups')
                                                ->scalarPrototype()->end()
                                            ->end()
                                        ->end()
                                    ->end()
                                    ->arrayNode('denormalization_context')
                                        ->children()
                                            ->arrayNode('groups')
                                                ->scalarPrototype()->end()
                                            ->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('filters')
                            ->beforeNormalization()->castToArray()->end()
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('className')->isRequired()->end()
                                    ->arrayNode('properties')
                                        ->beforeNormalization()->castToArray()->end()
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('operations')
                                        ->beforeNormalization()->castToArray()->end()
                                        ->scalarPrototype()->end()
                                    ->end()
                                    ->arrayNode('arguments')
                                        ->beforeNormalization()->castToArray()->end()
                                        ->arrayPrototype()
                                            ->prototype('mixed')->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('fields')
                            ->beforeNormalization()->castToArray()->end()
                            ->useAttributeAsKey('name')
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('type')->isRequired()->end()
                                    ->booleanNode('id')->defaultFalse()->end()
                                    ->booleanNode('nullable')->defaultFalse()->end()
                                    ->arrayNode('annotations')
                                        ->arrayPrototype()
                                            ->prototype('mixed')->end()
                                        ->end()
                                    ->end()
                                    ->arrayNode('groups')
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->booleanNode('register_get_one')->defaultFalse()->end()
                        ->booleanNode('register_get_collection')->defaultFalse()->end()
                        ->booleanNode('register_create_one')->defaultFalse()->end()
                        ->booleanNode('register_full_update_one')->defaultFalse()->end()
                        ->booleanNode('register_update_one')->defaultFalse()->end()
                        ->booleanNode('register_delete_one')->defaultFalse()->end()
                    ->end()
                ->end()
            ->end();
    }

    private function buildDoctrineEntitiesConfigurationNode(NodeBuilder $parent): void
    {
        $parent
            ->arrayNode('doctrine')
                ->beforeNormalization()->castToArray()->end()
                ->useAttributeAsKey('className')
                ->arrayPrototype()
                    ->children()
                        ->scalarNode('idType')->defaultValue('int')->end()
                        ->scalarNode('table')->isRequired()->end()
                        ->arrayNode('traits')
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('interfaces')
                            ->scalarPrototype()->end()
                        ->end()
                        ->scalarNode('extends')->defaultNull()->end()
                        ->arrayNode('annotations')
                            ->arrayPrototype()
                                ->prototype('mixed')->end()
                            ->end()
                        ->end()
                        ->arrayNode('factory')
                            ->children()
                                ->arrayNode('interfaces')
                                    ->scalarPrototype()->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('repository')
                            ->children()
                                ->arrayNode('traits')
                                    ->scalarPrototype()->end()
                                ->end()
                                ->arrayNode('interfaces')
                                    ->scalarPrototype()->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('queryBuilder')
                            ->children()
                                ->arrayNode('traits')
                                    ->scalarPrototype()->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('indexes')
                            ->beforeNormalization()->castToArray()->end()
                            ->useAttributeAsKey('name')
                            ->arrayPrototype()
                                ->children()
                                    ->arrayNode('fields')
                                        ->cannotBeEmpty()
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('uniqueIndexes')
                            ->beforeNormalization()->castToArray()->end()
                            ->useAttributeAsKey('name')
                            ->arrayPrototype()
                                ->children()
                                    ->arrayNode('fields')
                                        ->cannotBeEmpty()
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('fields')
                            ->beforeNormalization()->castToArray()->end()
                            ->useAttributeAsKey('name')
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('type')->isRequired()->end()
                                    ->booleanNode('id')->defaultFalse()->end()
                                    ->booleanNode('nullable')->defaultFalse()->end()
                                    ->integerNode('length')->defaultNull()->end()
                                    ->integerNode('precision')->defaultNull()->end()
                                    ->integerNode('scale')->defaultNull()->end()
                                    ->booleanNode('fixed')->defaultFalse()->end()
                                    ->arrayNode('annotations')
                                        ->arrayPrototype()
                                            ->prototype('mixed')->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end();
    }

    private function buildLogicEntitiesConfigurationNode(NodeBuilder $parent): void
    {
        $parent
            ->arrayNode('logic')
                ->beforeNormalization()->castToArray()->end()
                ->useAttributeAsKey('className')
                ->arrayPrototype()
                    ->children()
                        ->scalarNode('idType')->defaultValue('int')->end()
                        ->scalarNode('doctrineEntity')->defaultNull()->end()
                        ->arrayNode('traits')
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('interfaces')
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('annotations')
                            ->arrayPrototype()
                                ->prototype('mixed')->end()
                            ->end()
                        ->end()
                        ->arrayNode('factory')
                            ->children()
                                ->arrayNode('interfaces')
                                    ->scalarPrototype()->end()
                                ->end()
                            ->end()
                        ->end()
                        ->booleanNode('generate_new_entity')->defaultTrue()->end()
                        ->booleanNode('generate_get_one')->defaultFalse()->end()
                        ->booleanNode('generate_get_collection')->defaultFalse()->end()
                        ->booleanNode('generate_create_one')->defaultFalse()->end()
                        ->booleanNode('generate_update_one')->defaultFalse()->end()
                        ->booleanNode('generate_delete_one')->defaultFalse()->end()
                        ->booleanNode('use_doctrine_get_one')->defaultFalse()->end()
                        ->booleanNode('use_doctrine_get_collection')->defaultFalse()->end()
                        ->booleanNode('use_doctrine_create_one')->defaultFalse()->end()
                        ->booleanNode('use_doctrine_update_one')->defaultFalse()->end()
                        ->booleanNode('use_doctrine_delete_one')->defaultFalse()->end()
                        ->scalarNode('enricher')->defaultNull()->end()
                        ->arrayNode('fields')
                            ->beforeNormalization()->castToArray()->end()
                            ->useAttributeAsKey('name')
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('type')->isRequired()->end()
                                    ->booleanNode('id')->defaultFalse()->end()
                                    ->booleanNode('nullable')->defaultFalse()->end()
                                    ->arrayNode('annotations')
                                        ->arrayPrototype()
                                            ->prototype('mixed')->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end();
    }

    private function buildLogicRequestEntitiesConfigurationNode(NodeBuilder $parent): void
    {
        $parent
            ->arrayNode('logic_request')
                ->beforeNormalization()->castToArray()->end()
                ->useAttributeAsKey('className')
                ->arrayPrototype()
                    ->children()
                        ->scalarNode('type')->defaultNull()->end()
                        ->scalarNode('entity')->defaultNull()->end()
                        ->arrayNode('traits')
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('interfaces')
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('annotations')
                            ->arrayPrototype()
                                ->prototype('mixed')->end()
                            ->end()
                        ->end()
                        ->arrayNode('factory')
                            ->children()
                                ->arrayNode('interfaces')
                                    ->scalarPrototype()->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('fields')
                            ->beforeNormalization()->castToArray()->end()
                            ->useAttributeAsKey('name')
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('type')->isRequired()->end()
                                    ->booleanNode('nullable')->defaultFalse()->end()
                                    ->arrayNode('annotations')
                                        ->arrayPrototype()
                                            ->prototype('mixed')->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end();
    }

    private function buildLogicResponseEntitiesConfigurationNode(NodeBuilder $parent): void
    {
        $parent
            ->arrayNode('logic_response')
                ->beforeNormalization()->castToArray()->end()
                ->useAttributeAsKey('className')
                ->arrayPrototype()
                    ->children()
                        ->scalarNode('type')->defaultNull()->end()
                        ->scalarNode('entity')->defaultNull()->end()
                        ->arrayNode('traits')
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('interfaces')
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('annotations')
                            ->arrayPrototype()
                                ->prototype('mixed')->end()
                            ->end()
                        ->end()
                        ->arrayNode('factory')
                            ->children()
                                ->arrayNode('interfaces')
                                    ->scalarPrototype()->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('fields')
                            ->beforeNormalization()->castToArray()->end()
                            ->useAttributeAsKey('name')
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('type')->isRequired()->end()
                                    ->booleanNode('nullable')->defaultFalse()->end()
                                    ->arrayNode('annotations')
                                        ->arrayPrototype()
                                            ->prototype('mixed')->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end();
    }

    private function buildDTOConfigurationNode(NodeBuilder $parent): void
    {
        $parent
            ->arrayNode('dto')
                ->beforeNormalization()->castToArray()->end()
                ->useAttributeAsKey('className')
                ->arrayPrototype()
                    ->children()
                        ->scalarNode('type')->defaultNull()->end()
                        ->booleanNode('trait')->defaultFalse()->end()
                        ->arrayNode('traits')
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('uses')
                            ->scalarPrototype()->end()
                        ->end()
                        ->arrayNode('interfaces')
                            ->scalarPrototype()->end()
                        ->end()
                        ->scalarNode('extends')->defaultNull()->end()
                        ->arrayNode('annotations')
                            ->arrayPrototype()
                                ->prototype('mixed')->end()
                            ->end()
                        ->end()
                        ->arrayNode('factory')
                            ->children()
                                ->arrayNode('interfaces')
                                    ->scalarPrototype()->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('fields')
                            ->beforeNormalization()->castToArray()->end()
                            ->useAttributeAsKey('name')
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('type')->isRequired()->end()
                                    ->booleanNode('nullable')->defaultFalse()->end()
                                    ->arrayNode('annotations')
                                        ->arrayPrototype()
                                            ->prototype('mixed')->end()
                                        ->end()
                                    ->end()
                                    ->arrayNode('groups')
                                        ->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end();
    }

    private function buildTransformers(NodeBuilder $parent): void
    {
        $parent
            ->arrayNode('transformers')
                ->beforeNormalization()->castToArray()->end()
                ->arrayPrototype()
                    ->children()
                        ->scalarNode('from')->isRequired()->end()
                        ->scalarNode('to')->isRequired()->end()
                        ->scalarNode('type')->defaultNull()->end()
                        ->scalarNode('pattern')->defaultValue('serialization')->end()
                    ->end()
                ->end()
            ->end();
    }

    private function buildEnumerations(NodeBuilder $parent): void
    {
        $parent
            ->arrayNode('enumerations')
                ->beforeNormalization()->castToArray()->end()
                ->useAttributeAsKey('className')
                ->arrayPrototype()
                    ->children()
                        ->arrayNode('items')
                            ->beforeNormalization()->castToArray()->end()
                            ->useAttributeAsKey('name')
                            ->arrayPrototype()
                                ->children()
                                    ->scalarNode('value')->defaultNull()->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end();
    }

    private function buildHashMaps(NodeBuilder $parent): void
    {
        $parent
            ->arrayNode('hashMaps')
                ->beforeNormalization()->castToArray()->end()
                ->useAttributeAsKey('className')
                ->arrayPrototype()
                    ->children()
                        ->scalarNode('keyType')->isRequired()->end()
                        ->scalarNode('valueType')->isRequired()->end()
                    ->end()
                ->end()
            ->end();
    }
}
