<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use XCart\Bundle\DTOGeneratorBundle\Service\Generator\Transformer;
use XCart\Bundle\DTOGeneratorBundle\Service\Generator\TransformerInterface;

class TransformerGenerationPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        /** @var Transformer $generator */
        $generator = $container->get('xcart.dto_generator.generator.transformer');
        $generator->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.transformers')
        );

        /** @var TransformerInterface $generator */
        $generator = $container->get('xcart.dto_generator.generator.transformer_interface');
        $generator->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.transformers')
        );
    }
}
