<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use XCart\Bundle\DTOGeneratorBundle\Service\ServiceLocatorsRegister;

class ServiceLocatorsRegistrationPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        /** @var ServiceLocatorsRegister $register */
        $register = $container->get('xcart.dto_generator.service_locators_register');
        $register->register(
            $container,
            $container->get('xcart.dto_generator.data_provider.all_entities')
        );
    }
}
