<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Reference;
use XCart\Bundle\DTOGeneratorBundle\Service\NameResolverInterface;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DoctrineEntitiesDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;

class RegisterWriteDataSourcesPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        if (!$container->hasDefinition('xcart.dto_generator.data_provider.doctrine_entities')) {
            return;
        }

        /** @var NameResolverInterface $nameResolver */
        $nameResolver = $container->get(NameResolverInterface::class);

        /** @var DataProvider $dataProvider */
        $dataProvider = $container->get('xcart.dto_generator.data_provider.doctrine_entities');
        /** @var Entity $entity */
        foreach ($dataProvider as $entity) {
            $className = $nameResolver->buildDataSourceWriteClassName($entity->className);
            $definition = (new Definition($className))
                ->setAutowired(true)
                ->setArgument('$repository', new Reference($nameResolver->buildRepositoryWriteId($entity->className)))
                ->setArgument('$collectionClassName', $nameResolver->buildCollectionClassName($entity->className));

            $container->setDefinition($className, $definition);

            $container->setAlias($nameResolver->buildDataSourceWriteInterfaceName($entity->className), $className);
            $container->setAlias($nameResolver->buildDataSourceWriteId($entity->className), $className);
        }
    }
}
