<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Reference;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\Factory\QueryBuilderFactory;
use XCart\Bundle\DTOGeneratorBundle\Service\NameResolverInterface;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DoctrineEntitiesDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;

class RegisterReadQueryBuilderFactoriesPass implements CompilerPassInterface
{
    private const ENTITY_MANAGER_ID = 'doctrine.orm.entity_manager';
    private const WRITE_ENTITY_MANAGER_ID = 'doctrine.orm.write_entity_manager';
    private const READ_ENTITY_MANAGER_ID = 'doctrine.orm.read_entity_manager';

    public function process(ContainerBuilder $container): void
    {
        if (!$container->hasDefinition('xcart.dto_generator.data_provider.doctrine_entities')) {
            return;
        }

        if ($container->hasDefinition(self::READ_ENTITY_MANAGER_ID)) {
            $entityManagerId = self::READ_ENTITY_MANAGER_ID;
        } elseif ($container->hasDefinition(self::WRITE_ENTITY_MANAGER_ID)) {
            $entityManagerId = self::WRITE_ENTITY_MANAGER_ID;
        } else {
            $entityManagerId = self::ENTITY_MANAGER_ID;
        }

        /** @var NameResolverInterface $nameResolver */
        $nameResolver = $container->get(NameResolverInterface::class);

        /** @var DataProvider $dataProvider */
        $dataProvider = $container->get('xcart.dto_generator.data_provider.doctrine_entities');
        /** @var Entity $entity */
        foreach ($dataProvider as $entity) {
            $className = $nameResolver->buildQueryBuilderClassName($entity->className);
            $id = $nameResolver->buildQueryBuilderFactoryReadID($entity->className);
            $definition = (new Definition())
                ->setClass(QueryBuilderFactory::class)
                ->setArgument('$entityManager', new Reference($entityManagerId))
                ->setArgument('$className', $className);

            $container->setDefinition($id, $definition);
        }
    }
}
