<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class PreparationPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $container->get('xcart.dto_generator.autoloader')->register();

        $container->get('xcart.dto_generator.preparer')
            ->prepare($container->getParameter('xcart.dto_generator.directory'));

        $container->get('xcart.dto_generator.postprocessor.api_entities')
            ->normalize($container->get('xcart.dto_generator.data_provider.api_entities'));

        $container->get('xcart.dto_generator.postprocessor.doctrine_entities')
            ->normalize($container->get('xcart.dto_generator.data_provider.doctrine_entities'));

        $container->get('xcart.dto_generator.postprocessor.logic_entities')
            ->normalize($container->get('xcart.dto_generator.data_provider.logic_entities'));

        $container->get('xcart.dto_generator.postprocessor.logic_request_entities')
            ->normalize($container->get('xcart.dto_generator.data_provider.logic_request_entities'));

        $container->get('xcart.dto_generator.postprocessor.logic_response_entities')
            ->normalize($container->get('xcart.dto_generator.data_provider.logic_response_entities'));

        $container->get('xcart.dto_generator.postprocessor.dto')
            ->normalize($container->get('xcart.dto_generator.data_provider.dto'));

        $container->get('xcart.dto_generator.postprocessor.transformers')
            ->normalize($container->get('xcart.dto_generator.data_provider.transformers'));

        $container->get('xcart.dto_generator.postprocessor.enumerations')
            ->normalize($container->get('xcart.dto_generator.data_provider.enumerations'));

        $container->get('xcart.dto_generator.postprocessor.hash_maps')
            ->normalize($container->get('xcart.dto_generator.data_provider.hash_maps'));
    }
}
