<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class NormalizationPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $container->get('xcart.dto_generator.entities_normalizer.api_entities')->normalize();
        $container->get('xcart.dto_generator.entities_normalizer.doctrine_entities')->normalize();
        $container->get('xcart.dto_generator.entities_normalizer.logic_entities')->normalize();
        $container->get('xcart.dto_generator.entities_normalizer.logic_request_entities')->normalize();
        $container->get('xcart.dto_generator.entities_normalizer.logic_response_entities')->normalize();
        $container->get('xcart.dto_generator.entities_normalizer.dto')->normalize();

        $container->get('xcart.dto_generator.entities_normalizer.transformers')->normalize();
    }
}
