<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use XCart\Bundle\DoctrineBridgeBundle\Transformer\OrderRule\Transformer;
use XCart\Bundle\DTOGeneratorBundle\Service\NameResolverInterface;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTODataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTO as Entity;

class LogicToDoctrineOrderRuleTransformersRegisterPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        if (!$container->hasDefinition('xcart.dto_generator.data_provider.dto')) {
            return;
        }

        /** @var NameResolverInterface $nameResolver */
        $nameResolver = $container->get(NameResolverInterface::class);

        /** @var DataProvider $dataProvider */
        $dataProvider = $container->get('xcart.dto_generator.data_provider.dto');
        /** @var Entity $entity */
        foreach ($dataProvider as $entity) {
            if (!$entity->type || $entity->type->getValue() !== $entity->type::DOCTRINE_ENTITY_ORDER_RULE) {
                continue;
            }

            $id = $nameResolver->buildDoctrineOrderRuleTransformerId($entity);
            $definition = (new Definition(Transformer::class))
                ->setArgument('$outputClassName', $entity->className);

            $container->setDefinition($id, $definition);
        }
    }
}
