<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class InitializationPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $container->getDefinition('xcart.dto_generator.data_provider.api_entities')
            ->addArgument($container->getParameter('xcart.dto_generator.config'));

        $container->getDefinition('xcart.dto_generator.data_provider.doctrine_entities')
            ->addArgument($container->getParameter('xcart.dto_generator.config'));

        $container->getDefinition('xcart.dto_generator.data_provider.logic_entities')
            ->addArgument($container->getParameter('xcart.dto_generator.config'));

        $container->getDefinition('xcart.dto_generator.data_provider.logic_request_entities')
            ->addArgument($container->getParameter('xcart.dto_generator.config'));

        $container->getDefinition('xcart.dto_generator.data_provider.logic_response_entities')
            ->addArgument($container->getParameter('xcart.dto_generator.config'));

        $container->getDefinition('xcart.dto_generator.data_provider.dto')
            ->addArgument($container->getParameter('xcart.dto_generator.config'));

        $container->getDefinition('xcart.dto_generator.data_provider.transformers')
            ->addArgument($container->getParameter('xcart.dto_generator.config'));

        $container->getDefinition('xcart.dto_generator.data_provider.enumerations')
            ->addArgument($container->getParameter('xcart.dto_generator.config'));

        $container->getDefinition('xcart.dto_generator.data_provider.hash_maps')
            ->addArgument($container->getParameter('xcart.dto_generator.config'));
    }
}
