<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DoctrineEntitiesDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\Service\Generator\DataSourceWriteInterfaceGenerator;

class GenerateDataSourceWriteInterfacesPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        if (!$container->hasDefinition('xcart.dto_generator.data_provider.doctrine_entities')) {
            return;
        }

        /** @var DataSourceWriteInterfaceGenerator $repositoryGenerator */
        $repositoryGenerator = $container->get(DataSourceWriteInterfaceGenerator::class);

        /** @var DataProvider $dataProvider */
        $dataProvider = $container->get('xcart.dto_generator.data_provider.doctrine_entities');
        $repositoryGenerator->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $dataProvider
        );
    }
}
