<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use XCart\Bundle\DTOGeneratorBundle\Service\Generator\Factory;

class FactoryGenerationPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        /** @var Factory $generator */
        $generator = $container->get('xcart.dto_generator.generator.factory');

        $generator->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.api_entities')
        );

        $generator->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.doctrine_entities')
        );

        $generator->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.logic_entities')
        );

        $generator->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.logic_request_entities')
        );

        $generator->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.logic_response_entities')
        );

        $generator->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.dto')
        );
    }
}
