<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class DTOGenerationPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $container->get('xcart.dto_generator.generator.api_entities')->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.api_entities')
        );

        $container->get('xcart.dto_generator.generator.doctrine_entities')->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.doctrine_entities')
        );

        $container->get('xcart.dto_generator.generator.logic_entities')->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.logic_entities')
        );

        $container->get('xcart.dto_generator.generator.logic_request_entities')->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.logic_request_entities')
        );

        $container->get('xcart.dto_generator.generator.logic_response_entities')->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.logic_response_entities')
        );

        $container->get('xcart.dto_generator.generator.dto')->generate(
            $container->getParameter('xcart.dto_generator.directory'),
            $container->getParameter('xcart.dto_generator.namespace'),
            $container->get('xcart.dto_generator.data_provider.dto')
        );
    }
}
