<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class CRUDRegistrationPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $container->get('xcart.dto_generator.register.crud.api')->register($container);
        $container->get('xcart.dto_generator.register.crud.logic')->register($container);
    }
}
