<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class BuilderPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $container->get('xcart.dto_generator.builder.new_logic_entities')->build();
        $container->get('xcart.dto_generator.builder.logic_request_response')->build();
        $container->get('xcart.dto_generator.builder.doctrine_filters')->build();
        $container->get('xcart.dto_generator.builder.logic_transformers')->build();
        $container->get('xcart.dto_generator.builder.api_transformers')->build();
    }
}
