<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider;

use Doctrine\Common\Collections\ArrayCollection;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Transformer as Entity;

/**
 * @method Entity[] toArray()
 * @method false|Entity first()
 * @method static createFrom(Entity[] $elements)
 * @method false|Entity last()
 * @method false|Entity next()
 * @method false|Entity current()
 * @method Entity|null remove(string $key)
 * @method bool removeElement(Entity $element)
 * @method Entity|null offsetGet(string $offset)
 * @method void offsetSet(string $offset, Entity $value)
 * @method bool contains(Entity $element)
 * @method bool|string indexOf(Entity $element)
 * @method Entity|null get(string $key)
 * @method Entity[] getValues()
 * @method void set(string $key, Entity $value)
 * @method bool add(Entity $element)
 * @method Entity[] slice(int $offset, ?int $length = null)
 */
final class TransformersDataProvider extends ArrayCollection
{
    public function getByFromTo(string $from, string $to): ?Entity
    {
        foreach ($this as $transformer) {
            if ($transformer->from === $from && $transformer->to === $to) {
                return $transformer;
            }
        }

        return null;
    }
}
