<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\Factory;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\TransformersDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Transformer as Entity;
use XCart\Bundle\DTOGeneratorBundle\Enum\TransformerPattern;
use XCart\Bundle\DTOGeneratorBundle\Enum\TransformerType;

class TransformersDataProviderFactory
{
    public function __invoke(array $config): DataProvider
    {
        return $this->buildDataProvider($config);
    }

    private function buildDataProvider(array $config): DataProvider
    {
        $dataProvider = new DataProvider();

        if (empty($config['transformers'])) {
            return $dataProvider;
        }

        foreach ($config['transformers'] as $entity) {
            $object = new Entity();
            $object->from = $entity['from'];
            $object->to = $entity['to'];
            $object->type = $entity['type'] ? TransformerType::from($entity['type']) : null;
            $object->pattern = $entity['pattern']
                ? TransformerPattern::from($entity['pattern'])
                : TransformerPattern::SERIALIZATION();

            $dataProvider->add($object);
        }

        return $dataProvider;
    }
}
