<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\Factory;

use XCart\Bundle\DTOGeneratorBundle\Collection\Annotations;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\LogicResponseEntitiesDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicResponseEntity as Entity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Factory;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Field;
use XCart\Bundle\DTOGeneratorBundle\Enum\LogicResponseType;

class LogicResponseEntitiesDataProviderFactory
{
    public function __invoke(array $config): DataProvider
    {
        return $this->buildDataProvider($config);
    }

    private function buildDataProvider(array $config): DataProvider
    {
        $dataProvider = new DataProvider();

        if (empty($config['entities']) || empty($config['entities']['logic_response'])) {
            return $dataProvider;
        }

        foreach ($config['entities']['logic_response'] as $className => $entity) {
            $object = new Entity();
            $object->annotations = Annotations::buildFromArray($entity['annotations'] ?? []);
            $object->className = $className;
            $object->type = $entity['type'] ? LogicResponseType::from($entity['type']) : null;
            $object->entity = $entity['entity'] ?? null;
            $object->traits = $entity['traits'] ?? [];
            $object->interfaces = $entity['interfaces'] ?? [];

            $object->factory = new Factory();
            $object->factory->interfaces = $entity['factory']['interfaces'] ?? [];

            foreach ($entity['fields'] as $name => $field) {
                $fieldEntity = new Field();
                $fieldEntity->annotations = Annotations::buildFromArray($field['annotations'] ?? []);
                $fieldEntity->type = $field['type'];
                $fieldEntity->name = $name;
                $fieldEntity->nullable = $field['nullable'] ?? false;

                $object->fields[$name] = $fieldEntity;
            }

            $dataProvider->set($object->className, $object);
        }

        return $dataProvider;
    }
}
