<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\Factory;

use XCart\Bundle\DTOGeneratorBundle\Collection\Annotations;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\LogicEntitiesDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicEntity as Entity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Factory;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\EntityField as Field;

class LogicEntitiesDataProviderFactory
{
    public function __invoke(array $config): DataProvider
    {
        return $this->buildDataProvider($config);
    }

    private function buildDataProvider(array $config): DataProvider
    {
        $dataProvider = new DataProvider();

        if (empty($config['entities']) || empty($config['entities']['logic'])) {
            return $dataProvider;
        }

        foreach ($config['entities']['logic'] as $className => $entity) {
            $object = new Entity();
            $object->annotations = Annotations::buildFromArray($entity['annotations'] ?? []);
            $object->className = $className;
            $object->idType = $entity['idType'];
            $object->traits = $entity['traits'] ?? [];
            $object->interfaces = $entity['interfaces'] ?? [];
            $object->generateNewEntity = $entity['generate_new_entity'] ?? false;
            $object->generateGetOne = $entity['generate_get_one'] ?? false;
            $object->generateGetCollection = $entity['generate_get_collection'] ?? false;
            $object->generateCreateOne = $entity['generate_create_one'] ?? false;
            $object->generateUpdateOne = $entity['generate_update_one'] ?? false;
            $object->generateDeleteOne = $entity['generate_delete_one'] ?? false;
            $object->useDoctrineGetOne = $entity['use_doctrine_get_one'] ?? false;
            $object->useDoctrineGetCollection = $entity['use_doctrine_get_collection'] ?? false;
            $object->useDoctrineCreateOne = $entity['use_doctrine_create_one'] ?? false;
            $object->useDoctrineUpdateOne = $entity['use_doctrine_update_one'] ?? false;
            $object->useDoctrineDeleteOne = $entity['use_doctrine_delete_one'] ?? false;
            $object->doctrineEntity = $entity['doctrineEntity'] ?? null;

            $object->enricher = $entity['enricher'] ?? null;

            $object->factory = new Factory();
            $object->factory->interfaces = $entity['factory']['interfaces'] ?? [];

            foreach ($entity['fields'] as $name => $field) {
                $fieldEntity = new Field();
                $fieldEntity->annotations = Annotations::buildFromArray($field['annotations'] ?? []);
                $fieldEntity->type = $field['type'];
                $fieldEntity->name = $name;
                $fieldEntity->nullable = $field['nullable'] ?? false;
                $fieldEntity->id = $field['id'] ?? false;

                $object->fields[$name] = $fieldEntity;
            }

            $dataProvider->set($object->className, $object);
        }

        return $dataProvider;
    }
}
