<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\Factory;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\HashMapsDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\HashMap as Entity;

class HashMapsDataProviderFactory
{
    public function __invoke(array $config): DataProvider
    {
        return $this->buildDataProvider($config);
    }

    private function buildDataProvider(array $config): DataProvider
    {
        $dataProvider = new DataProvider();

        if (empty($config['hashMaps'])) {
            return $dataProvider;
        }

        foreach ($config['hashMaps'] as $className => $entity) {
            $object = new Entity();
            $object->className = $className;
            $object->keyType = $entity['keyType'];
            $object->valueType = $entity['valueType'];

            $dataProvider->add($object);
        }

        return $dataProvider;
    }
}
