<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\Factory;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\EnumerationsDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Enumeration as Entity;

class EnumerationsDataProviderFactory
{
    public function __invoke(array $config): DataProvider
    {
        return $this->buildDataProvider($config);
    }

    private function buildDataProvider(array $config): DataProvider
    {
        $dataProvider = new DataProvider();

        if (empty($config['enumerations'])) {
            return $dataProvider;
        }

        foreach ($config['enumerations'] as $className => $entity) {
            $object = new Entity();
            $object->className = $className;

            foreach ($entity['items'] as $key => $value) {
                $object->items[$key] = $value['value'] ?? $key;
            }

            $dataProvider->add($object);
        }

        return $dataProvider;
    }
}
