<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\Factory;

use XCart\Bundle\DTOGeneratorBundle\Collection\Annotations;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DoctrineEntitiesDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineIndex;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Factory;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineField as Field;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\QueryBuilder;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Repository;

final class DoctrineEntitiesDataProviderFactory
{
    public function __invoke(array $config): DataProvider
    {
        return $this->buildDataProvider($config);
    }

    private function buildDataProvider(array $config): DataProvider
    {
        $dataProvider = new DataProvider();

        if (empty($config['entities']) || empty($config['entities']['doctrine'])) {
            return $dataProvider;
        }

        foreach ($config['entities']['doctrine'] as $className => $entity) {
            $object = new Entity();
            $object->annotations = Annotations::buildFromArray($entity['annotations'] ?? []);
            $object->className = $className;
            $object->idType = $entity['idType'];
            $object->traits = $entity['traits'] ?? [];
            $object->interfaces = $entity['interfaces'] ?? [];
            $object->table = $entity['table'] ?? null;
            $object->extends = $entity['extends'] ?? null;

            $object->factory = new Factory();
            $object->factory->interfaces = $entity['factory']['interfaces'] ?? [];

            $object->repository = new Repository();
            $object->repository->traits = $entity['repository']['traits'] ?? [];
            $object->repository->interfaces = $entity['repository']['interfaces'] ?? [];

            $object->queryBuilder = new QueryBuilder();
            $object->queryBuilder->traits = $entity['queryBuilder']['traits'] ?? [];

            foreach ($entity['indexes'] as $name => $index) {
                $indexEntity = new DoctrineIndex();
                $indexEntity->name = $name;
                $indexEntity->fields = $index['fields'];
                $object->indexes[] = $indexEntity;
            }

            foreach ($entity['uniqueIndexes'] as $name => $index) {
                $indexEntity = new DoctrineIndex();
                $indexEntity->name = $name;
                $indexEntity->fields = $index['fields'];
                $object->uniqueIndexes[] = $indexEntity;
            }

            foreach ($entity['fields'] as $name => $field) {
                $fieldEntity = new Field();
                $fieldEntity->annotations = Annotations::buildFromArray($field['annotations'] ?? []);
                $fieldEntity->type = $field['type'];
                $fieldEntity->name = $name;
                $fieldEntity->nullable = $field['nullable'] ?? false;
                $fieldEntity->id = $field['id'] ?? false;
                $fieldEntity->fixed = $field['fixed'] ?? false;
                $fieldEntity->length = $field['length'] ?? null;
                $fieldEntity->precision = $field['precision'] ?? null;
                $fieldEntity->scale = $field['scale'] ?? null;

                $object->fields[$name] = $fieldEntity;
            }

            $dataProvider->set($object->className, $object);
        }

        return $dataProvider;
    }
}
