<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\Factory;

use XCart\Bundle\DTOGeneratorBundle\Collection\Annotations;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTO;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Factory;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Field;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTODataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\Enum\DTOType;

class DTODataProviderFactory
{
    public function __invoke(array $config): DataProvider
    {
        return $this->buildDataProvider($config);
    }

    private function buildDataProvider(array $config): DataProvider
    {
        $dataProvider = new DataProvider();

        if (empty($config['entities']) || empty($config['entities']['dto'])) {
            return $dataProvider;
        }

        foreach ($config['entities']['dto'] as $className => $entity) {
            $object = new DTO();
            $object->className = $className;
            $object->type = $entity['type'] ? DTOType::from($entity['type']) : null;
            $object->annotations = Annotations::buildFromArray($entity['annotations'] ?? []);
            $object->interfaces = $entity['interfaces'] ?? [];
            $object->uses = $entity['uses'] ?? [];
            $object->extends = $entity['extends'] ?? null;
            $object->traits = $entity['traits'] ?? [];
            $object->trait = $entity['trait'] ?? false;

            $object->factory = new Factory();
            $object->factory->interfaces = $entity['factory']['interfaces'] ?? [];

            foreach ($entity['fields'] as $name => $field) {
                $fieldEntity = new Field();
                $fieldEntity->annotations = Annotations::buildFromArray($field['annotations'] ?? []);
                $fieldEntity->type = $field['type'];
                $fieldEntity->name = $name;
                $fieldEntity->nullable = $field['nullable'] ?? false;
                $fieldEntity->groups = $field['groups'] ?: ['all', 'read', 'insert', 'update'];

                $object->fields[$name] = $fieldEntity;
            }

            $dataProvider->set($object->className, $object);
        }

        return $dataProvider;
    }
}
