<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO;

use XCart\Bundle\DTOGeneratorBundle\Enum\TransformerPattern;
use XCart\Bundle\DTOGeneratorBundle\Enum\TransformerType;

class Transformer implements DTOInterface
{
    public function __construct()
    {
        $this->pattern = TransformerPattern::SERIALIZATION();
    }

    public string $from;

    public ?EntityInterface $fromEntity = null;

    public string $to;

    public ?EntityInterface $toEntity = null;

    public ?TransformerType $type = null;

    public TransformerPattern $pattern;

    public ?Transformer $intermediateTransformer = null;

    public ?EntityInterface $intermediateEntity = null;
}
