<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO;

/**
 * @property array<string, EntityField> $fields
 */
class LogicEntity extends AbstractEntity
{
    public const ID_TYPE_MANUAL = 'manual';
    public const ID_TYPE_INT = 'int';
    public const ID_TYPE_UUID4 = 'uuid4';

    public string $idType = self::ID_TYPE_INT;

    public bool $generateNewEntity = true;

    public bool $generateGetOne = false;

    public bool $generateGetCollection = false;

    public bool $generateCreateOne = false;

    public bool $generateUpdateOne = false;

    public bool $generateDeleteOne = false;

    public bool $useDoctrineGetOne = false;

    public bool $useDoctrineGetCollection = false;

    public bool $useDoctrineCreateOne = false;

    public bool $useDoctrineUpdateOne = false;

    public bool $useDoctrineDeleteOne = false;

    public ?string $doctrineEntity = null;

    public bool $new = false;

    public ?string $enricher = null;
}
