<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO;

/**
 * @property array<string, DoctrineField> $fields
 */
class DoctrineEntity extends AbstractEntity
{
    public const ID_TYPE_MANUAL = 'manual';
    public const ID_TYPE_INT = 'int';
    public const ID_TYPE_UUID4 = 'uuid4';

    public string $idType = self::ID_TYPE_INT;

    public string $table;

    public Repository $repository;

    public QueryBuilder $queryBuilder;

    /**
     * @var array<string, DoctrineIndex>
     */
    public array $indexes = [];

    /**
     * @var array<string, DoctrineIndex>
     */
    public array $uniqueIndexes = [];
}
