<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO;

use XCart\Bundle\DTOGeneratorBundle\Collection\Annotations;

abstract class AbstractEntity implements EntityInterface
{
    public function __construct()
    {
        $this->annotations = new Annotations();
        $this->factory = new Factory();
    }

    public string $className;

    public ?string $extends = null;

    /**
     * @var string[]
     */
    public array $interfaces = [];

    /**
     * @var string[]
     */
    public array $uses = [];

    /**
     * @var string[]
     */
    public array $traits = [];

    public Annotations $annotations;

    /**
     * @var array<string, FieldInterface>
     */
    public array $fields = [];

    public Factory $factory;
}
