<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO;

class APIOperation
{
    public function __construct()
    {
        $this->normalizationContext = new APIContext();
        $this->denormalizationContext = new APIContext();
    }

    public string $method = 'GET';

    public string $path;

    /**
     * @var list<non-empty-string>
     */
    public array $identifiers = [];

    /**
     * @var array<non-empty-string, non-empty-string>
     */
    public array $requirements = [];

    public array $openapiContext = [];

    public APIContext $normalizationContext;

    public APIContext $denormalizationContext;
}
