<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO;

/**
 * @property array<string, EntityField> $fields
 */
class APIEntity extends AbstractEntity
{
    public const ID_TYPE_MANUAL = 'manual';
    public const ID_TYPE_INT = 'int';
    public const ID_TYPE_UUID4 = 'uuid4';

    public function __construct()
    {
        parent::__construct();

        $this->normalizationContext = new APIContext();
        $this->denormalizationContext = new APIContext();
    }

    public string $idType = self::ID_TYPE_INT;

    public ?string $logicEntity = null;

    /**
     * @var APIFilter[]
     */
    public array $filters = [];

    /**
     * @var APIOperation[]
     */
    public array $itemOperations = [];

    /**
     * @var APIOperation[]
     */
    public array $collectionOperations = [];

    public APIContext $normalizationContext;

    public APIContext $denormalizationContext;

    public string $path;

    public string $name;

    public bool $registerGetOne = false;

    public bool $registerGetCollection = false;

    public bool $registerCreateOne = false;

    public bool $registerFullUpdateOne = false;

    public bool $registerUpdateOne = false;

    public bool $registerDeleteOne = false;
}
