<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DTOGeneratorBundle\DataProvider;

use Doctrine\Common\Collections\ArrayCollection;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\AbstractEntity;

class AbstractEntitiesDataProvider extends ArrayCollection
{
    public function hasClassName(string $className): bool
    {
        /** @var AbstractEntity $entity */
        foreach ($this as $entity) {
            if ($entity->className === $className) {
                return true;
            }
        }

        return false;
    }

    public function getByClassName(string $className): ?AbstractEntity
    {
        /** @var AbstractEntity $entity */
        foreach ($this as $entity) {
            if ($entity->className === $className) {
                return $entity;
            }
        }

        return null;
    }
}
