<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DTOGeneratorBundle;

use Symfony\Component\DependencyInjection\Compiler\PassConfig;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\BuilderPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\CollectionGenerationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\CRUDRegistrationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\DTOGenerationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\EnumerationGenerationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\FactoryGenerationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\FactoryInterfaceGenerationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\GenerateDataSourceReadInterfacesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\GenerateDataSourcesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\GenerateDataSourceWriteInterfacesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\GenerateQueryBuilderInterfacesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\GenerateQueryBuildersPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\GenerateReadRepositoryInterfacesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\GenerateRepositoriesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\GenerateWriteRepositoryInterfacesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\HashMapGenerationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\InitializationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\LogicToDoctrineFilterTransformersRegisterPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\LogicToDoctrineOrderRuleTransformersRegisterPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\NormalizationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\PreparationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\RegisterReadDataSourcesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\RegisterReadQueryBuilderFactoriesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\RegisterReadRepositoriesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\RegisterWriteDataSourcesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\RegisterWriteQueryBuilderFactoriesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\RegisterWriteRepositoriesPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\RegistrationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\ServiceLocatorsRegistrationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\TransformerGenerationPass;
use XCart\Bundle\DTOGeneratorBundle\DependencyInjection\Compiler\UpdateGeneratedEntitiesPass;

class DTOGeneratorBundle extends Bundle
{
    public function boot(): void
    {
        parent::boot();

        if ($this->container->has('xcart.dto_generator.autoloader')) {
            $this->container->get('xcart.dto_generator.autoloader')->register();
        }
    }

    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        $container->addCompilerPass(new InitializationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 700);
        $container->addCompilerPass(new UpdateGeneratedEntitiesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 699);

        $container->addCompilerPass(new BuilderPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 610);
        $container->addCompilerPass(new NormalizationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 600);

        $container->addCompilerPass(new PreparationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 550);

        $container->addCompilerPass(new DTOGenerationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 510);
        $container->addCompilerPass(new CollectionGenerationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 510);
        $container->addCompilerPass(new TransformerGenerationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 510);
        $container->addCompilerPass(new EnumerationGenerationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 510);
        $container->addCompilerPass(new HashMapGenerationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 510);
        $container->addCompilerPass(new FactoryGenerationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 510);
        $container->addCompilerPass(new FactoryInterfaceGenerationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 510);

        $container->addCompilerPass(new RegistrationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 502);
        $container->addCompilerPass(new ServiceLocatorsRegistrationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 500);

        $container->addCompilerPass(new GenerateRepositoriesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 450);
        $container->addCompilerPass(new GenerateQueryBuildersPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 448);
        $container->addCompilerPass(new GenerateQueryBuilderInterfacesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 446);
        $container->addCompilerPass(new GenerateReadRepositoryInterfacesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 444);
        $container->addCompilerPass(new GenerateWriteRepositoryInterfacesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 444);
        $container->addCompilerPass(new GenerateDataSourcesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 442);
        $container->addCompilerPass(new GenerateDataSourceReadInterfacesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 440);
        $container->addCompilerPass(new GenerateDataSourceWriteInterfacesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 440);

        $container->addCompilerPass(new LogicToDoctrineFilterTransformersRegisterPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 400);
        $container->addCompilerPass(new LogicToDoctrineOrderRuleTransformersRegisterPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 400);
        $container->addCompilerPass(new RegisterReadRepositoriesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 400);
        $container->addCompilerPass(new RegisterReadQueryBuilderFactoriesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 400);
        $container->addCompilerPass(new RegisterWriteRepositoriesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 400);
        $container->addCompilerPass(new RegisterWriteQueryBuilderFactoriesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 400);
        $container->addCompilerPass(new RegisterReadDataSourcesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 400);
        $container->addCompilerPass(new RegisterWriteDataSourcesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 400);
        $container->addCompilerPass(new CRUDRegistrationPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 400);
    }
}
