<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DTOGeneratorBundle\DTO;

final class Attribute
{
    private string $className;

    private array $arguments = [];

    public function getClassName(): string
    {
        return $this->className;
    }

    public function setClassName(string $className): Attribute
    {
        $this->className = $className;

        return $this;
    }

    public function getArguments(): array
    {
        return $this->arguments;
    }

    public function setArguments(array $arguments): Attribute
    {
        $this->arguments = $arguments;

        return $this;
    }
}
