<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Collection;

use Doctrine\Common\Collections\ArrayCollection;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Annotation;

final class Annotations extends ArrayCollection
{
    public static function buildFromArray(array $annotations): self
    {
        $collection = new self();

        foreach ($annotations as $name => $arguments) {
            $collection->addAnnotationFromArray($arguments, is_string($name) ? $name : null);
        }

        return $collection;
    }

    public function addAnnotationFromArray(array $arguments, ?string $name = null): self
    {
        $annotation = new Annotation();
        $annotation->name = $name ?? $arguments['_'];
        if (isset($arguments['_'])) {
            unset($arguments['_']);
        }

        $annotation->arguments = $arguments;

        $this[] = $annotation;

        return $this;
    }

    public function hasAnnotation(string $name): bool
    {
        /** @var Annotation $annotation */
        foreach ($this as $annotation) {
            if ($annotation->name === $name) {
                return true;
            }
        }

        return false;
    }

    public function sortByName(): self
    {
        $array = $this->toArray();
        usort(
            $array,
            static function (Annotation $a, Annotation $b) {
                return $a->name <=> $b->name;
            }
        );

        return new self($array);
    }

    /**
     * @return Annotation[]
     */
    public function getAnnotations(string $name): array
    {
        $result = [];

        /** @var Annotation $annotation */
        foreach ($this as $annotation) {
            if ($annotation->name === $name) {
                $result[] = $annotation;
            }
        }

        return $result;
    }

    public function setAnnotation(string $name, array $arguments = [], int $index = 0): self
    {
        $i = 0;
        foreach ($this as $annotation) {
            if ($annotation->name === $name) {
                if ($i === $index) {
                    $annotation->arguments = $arguments;

                    return $this;
                }

                $i++;
            }
        }

        return $this;
    }
}
