<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Autoloader;

class DTOAutoloader
{
    private string $directory;

    private string $namespace;

    private int $namespaceLength;

    private bool $registered = false;

    public function __construct(string $directory, string $namespace)
    {
        $this->directory = rtrim($directory, DIRECTORY_SEPARATOR);
        $this->namespace = trim($namespace, '\\');
        $this->namespaceLength = strlen($namespace);
    }

    public function register(): void
    {
        if ($this->registered) {
            return;
        }

        spl_autoload_register([$this, 'load']);
        $this->registered = true;
    }

    public function load(string $class_name): void
    {
        if (strncmp($class_name, $this->namespace, $this->namespaceLength) !== 0) {
            return;
        }

        $path = $this->getPath($class_name);
        if (file_exists($path)) {
            require_once $path;
        }
    }

    private function getPath(string $class_name): string
    {
        return $this->directory . DIRECTORY_SEPARATOR
            . str_replace('\\', DIRECTORY_SEPARATOR, substr($class_name, $this->namespaceLength + 1)) . '.php';
    }
}
