<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Transformer\OrderRule;

use ReflectionException;
use ReflectionObject;
use XCart\Bundle\CommonBundle\Assembler\MethodNameAssembler;
use XCart\Bundle\DoctrineBridgeBundle\DTO\OrderRule\OrderRuleInterface as DoctrineOrderRule;
use XCart\Bundle\DoctrineBridgeBundle\Enum\OrderRuleDirection;
use XCart\Bundle\LogicBundle\DTO\Request\OrderRule\OrderRuleInterface as LogicOrderRule;
use XCart\Bundle\LogicBundle\Enum\OrderRuleDirection as LogicOrderRuleDirection;

class Transformer implements TransformerInterface
{
    public function __construct(
        private string $outputClassName,
    ) {
    }

    public function transform(LogicOrderRule $logicOrderRule): DoctrineOrderRule
    {
        $reflectionObject = new ReflectionObject($logicOrderRule);

        $output = new $this->outputClassName();

        $reflectionOutputObject = new ReflectionObject($output);

        foreach ($reflectionObject->getProperties() as $property) {
            if ($property->isPublic()) {
                continue;
            }

            $getter = MethodNameAssembler::assembleGetterName($property->getName());
            if (!$reflectionObject->hasMethod($getter)) {
                continue;
            }
            try {
                /** @var LogicOrderRuleDirection $value */
                $value = $reflectionObject->getMethod($getter)->invoke($logicOrderRule);
            } catch (ReflectionException) {
                continue;
            }

            if ($value === null) {
                continue;
            }

            $doctrineValue = OrderRuleDirection::from($value->getValue());

            $setter = MethodNameAssembler::assembleSetterName($property->getName());
            if (!$reflectionOutputObject->hasMethod($setter)) {
                continue;
            }

            try {
                $reflectionOutputObject->getMethod($setter)->invoke($output, $doctrineValue);
            } catch (ReflectionException) {
                continue;
            }
        }

        return $output;
    }
}
