<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Transformer\Filter\Value;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\IntegerRangeValue as DoctrineValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\Range\IntegerRange;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\RangeFilterStrategyType as StrategyTypeAlias;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\IntegerRangeValue as LogicValue;

class IntegerRangeValueTransformer implements ValueTransformerInterface
{
    public function transform(LogicValue $logicValue): DoctrineValue
    {
        $range = (new IntegerRange())
            ->setBegin($logicValue->getValue()->getBegin())
            ->setEnd($logicValue->getValue()->getEnd());

        return (new DoctrineValue())
            ->setValue($range)
            ->setStrategy(StrategyTypeAlias::from($logicValue->getStrategy()->getValue()))
            ->setExclude($logicValue->isExclude());
    }
}
