<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Transformer\Filter\Value;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\DateTimeValue as DoctrineValue;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\NumberFilterStrategyType as StrategyTypeAlias;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\DateTimeValue as LogicValue;

class DateTimeValueTransformer implements ValueTransformerInterface
{
    public function transform(LogicValue $logicValue): DoctrineValue
    {
        return (new DoctrineValue())
            ->setValue($logicValue->getValue())
            ->setStrategy(StrategyTypeAlias::from($logicValue->getStrategy()->getValue()))
            ->setExclude($logicValue->isExclude());
    }
}
