<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\DoctrineBridgeBundle\Transformer\Filter;

use ReflectionException;
use ReflectionObject;
use Symfony\Component\DependencyInjection\ServiceLocator;
use XCart\Bundle\CommonBundle\Assembler\MethodNameAssembler;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\FilterInterface as DoctrineFilter;
use XCart\Bundle\DoctrineBridgeBundle\Transformer\Filter\Value\ValueTransformerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\FilterInterface as LogicFilter;

class Transformer implements TransformerInterface
{
    public function __construct(
        private ServiceLocator $valueTransformers,
        private string $outputClassName,
    ) {
    }

    public function transform(LogicFilter $logicFilter): DoctrineFilter
    {
        $reflectionObject = new ReflectionObject($logicFilter);

        $output = new $this->outputClassName();

        $reflectionOutputObject = new ReflectionObject($output);

        foreach ($reflectionObject->getProperties() as $property) {
            if ($property->isPublic()) {
                continue;
            }

            $type = $property->getType();
            if (!$type) {
                continue;
            }

            if (!$this->valueTransformers->has($type->getName())) {
                continue;
            }

            /** @var ValueTransformerInterface $valueTransformer */
            $valueTransformer = $this->valueTransformers->get($type->getName());
            $getter = MethodNameAssembler::assembleGetterName($property->getName());
            if (!$reflectionObject->hasMethod($getter)) {
                continue;
            }
            try {
                $value = $reflectionObject->getMethod($getter)->invoke($logicFilter);
            } catch (ReflectionException) {
                continue;
            }

            if ($value === null) {
                continue;
            }

            $doctrineValue = $valueTransformer->transform($value);

            $setter = MethodNameAssembler::assembleSetterName($property->getName());
            if (!$reflectionOutputObject->hasMethod($setter)) {
                continue;
            }
            try {
                $reflectionOutputObject->getMethod($setter)->invoke($output, $doctrineValue);
            } catch (ReflectionException) {
                continue;
            }
        }

        return $output;
    }
}
